

	#picaxe 20M2

start0: 'Premier programme en temps partag

'****** Nomination des ports entres **********************
	symbol cmd 		= pinC.5	'commande sur pin interruption 
	symbol fcf	 	= pinC.6	'fin de course fermeture
	symbol fco	 	= pinC.7	'fin de course ouverture	
	symbol sensib	= B.5		'pot lecture seuil sensibilit
	symbol courmot	= B.6		'lecture courant moteur
	symbol alert	= pinC.0	'lecture tat barrire IR
	symbol lecpot	= C.1		'ADC ou Fixe 1 = fermeture auto ; 0 = manuelle
	
'******* Nomination des variables **********	
	symbol mouv		= bit0	'bit tat "en mouvement" pour le flash 
	symbol souvre	= bit1	'mmo tat prcdent (1=ouverture; 0=fermeture)
	symbol obst		= bit2	'mmo dtection obstacle
	symbol fermauto	= bit3	'mmo fermauto ou manuel	
	symbol etat		= b1		'tat en cours 1=ouverture; 2=fermeture; 3= arret
	symbol seuil	= b2		'valeur seuil sensib
	symbol courant	= b3		'mesure du courant
	symbol tempo	= w13		'lecture temporisation
	
'******* Nomination des ports sorties	 
	symbol LedR		= B.0		'sortie flash	'
	symbol EmetIR	= B.1		'sortie Led IR
	symbol ouv		= B.2		'commande moteur ouverture
	symbol ferm		= B.3		'commande moteur fermeture
	
	'do:loop while cmd=0 		'attente rglage ADC simu
	
'******** Initialisation variables ********	
	low ouv: low ferm: low ledR	
	etat =3			'etat arret  la mise en route
	souvre=0			'memo fermeture la 1re commande sera ouverture
	readadc10 lecpot,tempo	'lecture tempo 
	if tempo > 900 then	'pot max, on passe en manuel ou pas de pot C.1  5 v
		fermauto=0		'fermauto en manuel		
	elseif tempo <20 then	'automatic sans pot C.1 est  0
		fermauto=1		'automatique
		tempo=4000		'tempo fixe 4 s
	else 				'pot position mdiane
		fermauto=1		'automatique
		tempo= 20*tempo	'rglage tempo 0,4s  18s
	endif
		
	pwmout EmetIR, 104, 211 'activation Emet IR PWM 38 kHz  16MHz	
'******** Interruption sur C.5 niveau haut *********	 
	setint %00100000 ,%00100000	

'******** Boucle principale ********		
	Do
		readadc sensib, seuil	'lecture du seuil		
	
		select  etat	'aiguillage suivant variable "etat"
		
		case 1 		' etat ouverture
			mouv=1	'pour le flash
			souvre=1	'mmo tat
			obst=0	'reset mmo obstacle IR
			
			do		'boucle ouverture
				low ferm : high ouv		'positionnement des relais ouverture				
			loop while fco=0 and etat=1		'tant que fco ouvert et pas de changementd'tat		
			if etat<>3 then
				etat=4				'etat fermeture auto 4 s
			endif
					
		case 2 		' tat fermeture		
			mouv=1	'pour le flash
			souvre=0	'mmo tat			
			do		'boucle fermeture
				readadc courmot, courant 	'lecture courant moteur
				if courant > seuil then		'si dpassemnt seuil
						obst=1		'mmo dtect obstacle 
						etat=1		'positionnement tat ouverture					
				endif
				
				if alert=1 then		'dtection alert IR
						etat=1	'position tat ouverture						 
				endif
				
				low ouv: high ferm	'on ferme!
			loop while fcf=0 and etat=2	'tant que fcf ouvert et pas de changement d'tat
			
			if alert=0 and obst =0	then	'pas de problmes ?					
					 etat =3		'alors,positionnement tat arret						
			endif								
		
		case 3		' tat arret ;flash OFF		
			low ouv : low ferm	'arret moteur		
			mouv=0			'arret du flash
			
		case 4		'tat automatique ; flash ON
			low ouv : low ferm			'arret moteur		
			do:loop while alert=1 and etat=4	'blocage par obstable IR si pas changement tat
			if fermauto =1 and etat=4 then	'si automatique =1 et etat 4
				pause tempo				'attente 4 s
				etat=2				'fermeture auto
						else			'sinon							
				etat=3				'arret
			endif
				
		end select
			
	loop	

interrupt:	'Ah, on a appuy sur le bouton !!

	do : loop while cmd=1 'attente relachement poussoir
	
	select etat
	
		case 1,2,4		'on est en tat 1,2 ou 4	
			etat = 3		'alors passage  l'tat 3 (arret)
					
		case 3 		'on est  l'arret
			if souvre=1 then 	' tat prcdent= ouverure 
					etat=2	' alors on passe en fermeture
			else 
					etat=1	' sinon, c'est le contraire
			endif
		
	end select
	setint %00100000 ,%00100000	'reset de l'interruption
	
	return	
	
start1:	'Second programme en temps partag uniquement pour le flash

	Do
	if mouv=1 then	'si mouvement
		high ledR	'a 
		pause 500	'cli
		low ledR	'gno
		pause 500	'te !
	endif
	loop
		